(in-package "CL-USER")
;; (load "dbmc-structs")
;; (load "helper-functions")
;; (load "syntax-check")
;; (load "type-check")
;; (load "simplify")
;; (load "unroll")

;;;Settings
(defvar *verbal* t)

;; (load "cnf")
;;(load "defvars.lisp" :if-does-not-exist nil)

(defvar *desc* (make-desc))

;the front end. this function syntax and type checks a given
;description, putting the formulas in dag form in the process.
(defun admit-desc1 (desc d)
  (when *verbal* (format t "~&admitting description~%"))
  (setf *counter* 0)
  (setf *sforms* t)
  (setf (desc-functs d) nil)
  (setf (desc-consts d) nil)
  (setf (desc-defs d) nil)
  (and (specp desc d)
       (dolist (fn (desc-functs d) t)
         (unless (fix-function fn d)
           (return nil)))
       (fix-defs d)
       (fix-section d 'init)
       (fix-section d 'trans)
       (fix-section d 'spec)))

(defun admit-desc (desc)
  (admit-desc1 desc *desc*))

(defun solve-desc1 (desc name steps solver)
  (simplify-desc desc)
  (format t "~&unrolling~%")
  (multiple-value-bind
      (uvars uspec)
      (unroll-desc desc steps)
    (declare (ignore uvars))
    (format t "~&simplifying-memories~%")
    (multiple-value-bind
	(mspec mvars m-oa-na-alist)
	(simplify-memories uspec)
;;      (setf desc (make-desc))
      (cond ((eq mspec *one*) (values t nil nil t))
	    ((eq mspec *zero*) (values nil nil nil t))
	    (t
	     (format t "~&converting to cnf.~%")
	     (multiple-value-bind
		 (clauses varray vcount ccount lcount)
		 (cnf mspec mvars (desc-vars desc))
	       (cond ((eq clauses nil) (values nil nil nil t))
		     ((eq clauses t) (values t nil nil t))
		     (t
		      (format t "~&printing.~%")
		      (setf uspec nil)
		      ;; (setf uvars nil)
		      (setf mspec nil)
		      (setf mvars nil)
		      (print-comp-cnf clauses varray name (eq solver :none) vcount ccount lcount)
		      (multiple-value-bind
			  (solution sos)
			  (solve solver name)
			  (values solution varray m-oa-na-alist sos))))))))))

(defun solve-desc (name steps solver)
  (solve-desc1 *desc* name steps solver))

;the main function.
(defun dbmc (name form steps solver &key (sp nil) (ap nil) (up t) (rp t))
;;  (load "defvars.lisp")
  (cond ((not (member solver '(:zchaff :siege :minisat :none))) 
	 (format t "Unknown solver: ~A~%" solver))
	(t
	 (setf *sp* sp)
	 (setf *ap* ap)
	 (setf *up* up)
	 (setf *rp* rp)
	 (when (admit-desc form)
	   (multiple-value-bind
	       (results varray m-oa-na-alist sos)
	       (solve-desc name steps solver)
	     (when sos (format t "~&Solved on simplification."))
	     (cond ((and (eq solver :none) (not sos)) nil)
		   ((not results)
		    (format t "~&Machine Spec is TRUE for all inputs.~%"))
		   ((eq results t)
		    (format t "~&Machine Spec is FALSE for all inputs.~%"))
		   (t
		    (format t "Counterexample found.~%")
		    (print-results results
				   varray
				   (desc-vars *desc*)
				   m-oa-na-alist
				   steps))))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; solving individual formulas ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun admit-formula (vars functs form d)
    (when *verbal* (format t "~&admitting formula~%"))
    (setf *counter* 0)
    (setf *sforms* t)
    (setf (desc-functs d) nil)
    (setf (desc-consts d) nil)
    (setf (desc-defs d) nil)
    (when (and (formp vars functs form d)
	       (dolist (fn (desc-functs d) t)
		 (unless (fix-function fn d)
		   (return nil))))
      (let ((f (type-check-1 form nil (desc-tl-env d) d)))
	(if f (values t (tl-fix-ints f d)) (values nil nil)))))

(defun solve-formula (name vars functs form solver forall? d)
  (multiple-value-bind
      (valid-formp form)
      (admit-formula vars functs form d)
    (if (not valid-formp)
	(values nil nil nil nil nil)
      (let ((nform (if forall?
		       (sb-not-form (simplify-form form d))
		     (simplify-form form d))))
	(format t "~&simplifying memories.~%")
	(multiple-value-bind
	    (mform mvars m-oa-na-alist)
	    (simplify-memories nform)
	  (cond ((eq mform *one*) (values t t nil nil t))
		((eq mform *zero*) (values t nil nil nil t))
		(t
		 (format t "~&converting to cnf.~%")
		 (multiple-value-bind
		     (clauses varray vcount ccount lcount)
		     (cnf mform mvars vars)
		   (cond ((eq clauses nil) (values t nil nil nil t))
			 ((eq clauses t) (values t t nil nil t))
			 (t
			  (setf nform nil)
			  (setf mform nil)
			  (setf mvars nil)
			  (format t "~&printing.~%")
			  (print-comp-cnf clauses varray name (eq solver :none) vcount ccount lcount)
			  (multiple-value-bind
			      (solution sos)
			      (solve solver name)
			      (values t solution varray m-oa-na-alist sos))))))))))))
			 
(defun solve-formula-exists (name vars functs form solver &key (sp nil) (ap nil) (up t) (rp t))	  
;;  (load "defvars.lisp")
  (cond ((not (member solver '(:zchaff :siege :minisat :none))) 
	 (format t "Unknown solver: ~A~%" solver))
	(t
	 (setf *sp* sp)
	 (setf *ap* ap)
	 (setf *up* up)
	 (setf *rp* rp)
	 (multiple-value-bind
	     (valid results varray mona sos)
	     (solve-formula name vars functs form solver nil *desc*)
	   (when valid
	     (when sos (format t "~&Solved on simplification."))
	     (cond ((and (eq solver :none) (not sos)) nil)
		   ((not results)
		    (format t "~&Formula is FALSE for all inputs.~%"))
		   ((eq results t)
		    (format t "~&Formula is TRUE for all inputs.~%"))
		   (t
		    (format t "~&Formula is TRUE for the following inputs.~%")
		    (print-results results
				   varray
				   (desc-vars *desc*)
				   mona
				   0))))))))

(defun solve-formula-forall (name vars functs form solver &key (sp nil) (ap nil) (up t) (rp t))	  
;;  (load "defvars.lisp")
  (cond ((not (member solver '(:zchaff :siege :minisat :none))) 
	 (format t "Unknown solver: ~A~%" solver))
	(t
	 (setf *sp* sp)
	 (setf *ap* ap)
	 (setf *up* up)
	 (setf *rp* rp)
	 (multiple-value-bind
	     (valid results varray mona sos)
	     (solve-formula name vars functs form solver t *desc*)
	   (when valid
	     (when sos (format t "~&Solved on simplification."))
	     (cond ((and (eq solver :none) (not sos)) nil)
		   ((not results)
		    (format t "~&Formula is TRUE for all inputs.~%"))
		   ((eq results t)
		    (format t "~&Formula is FALSE for all inputs.~%"))
		   (t
		    (format t "~&Formula is FALSE for the following inputs.~%")
		    (print-results results
				   varray
				   (desc-vars *desc*)
				   mona
				   0))))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Compute Functionality ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun no-vars (expr)
  (if (consp expr)
      (and (not (assoc (first expr)
		       (desc-vars *desc*)
		       :test 'eq))
	   (not (assoc (first expr)
		       (desc-defs *desc*)
		       :test 'eq))
	   (dolist (x (rest expr) t)
	     (unless (no-vars x) (return nil))))
    (not (or (assoc expr (desc-vars *desc*) :test 'eq)
	     (assoc expr (desc-defs *desc*) :test 'eq)))))

;; (defun const-to-symbol (const)
;;   (let ((x (read-from-string (const-to-str const))))
;;     x))

(defun compute-const-listp (lst)
  (or (endp lst)
      (and (or (eq (car lst) *zero*)
	       (eq (car lst) *one*))
	   (compute-const-listp (cdr lst)))))

(defun strip-form-list (forms)
  (if (endp forms)
      nil
    (cons (strip-form (car forms))
	  (strip-form-list (cdr forms)))))

(defun strip-form (form)
  (cond ((not (formula-p form)) form)
	((eq form *one*) '0b1)
	((eq form *zero*) '0b0)
	((and (eq (formula-fn form) 'cat)
	      (compute-const-listp (formula-args form)))
	 (const-to-symbol form))
	(t
	 (cons (formula-fn form)
	       (strip-form-list (formula-args form))))))

(defun compute-fn (expr)
  (when (and (compute-formulap expr (append (desc-defs *desc*) (desc-vars *desc*)) *desc*)
	     (no-vars expr))
    (setf *ftrie* nil)
    (clrhash *fhash*)
    (with-formula
     form
     (tl-type-check expr nil (desc-vars *desc*) *desc*)
     (with-formula
      form
      (tl-fix-ints form *desc*)
      (with-formula
       form
       (tl-simplify form (desc-vars *desc*) (desc-defs *desc*) (desc-functs *desc*))
       (with-formula
	form
	(mem-rewrite form)
	(strip-form form)))))))

(defmacro compute (expr)
  `(compute-fn (quote ,expr)))
